/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     January 2002
 *
 */

#include  <gtk/gtk.h>


//extern  int format;


/* This procedure produces a window allowing selection of the
 * procedures for exploring the reference database */

void probe_menu(GtkWidget *widget)
{
  GtkTooltips *tooltips;
  GtkWidget   *window, *panel, *description, *selectionKeypad, *finish;
  GtkWidget   *separator, *keycentre;
  GtkWidget   *allkey, *allauthorkey, *allyearkey;
  GtkWidget   *wordkey, *authorkey, *yearkey, *refkey, *uplinkkey;
  GtkWidget   *journalkey, *typekey, *future3;
  GtkWidget   *spacer1key, *spacer2key;

  extern  void  close_window();   /* defined in file cleanup.c */
  extern  void  all();            /* defined in file listall.c */
  extern  void  word();           /* defined in file listword.c */
  extern  void  allyears();       /* defined in file listyears.c */
  extern  void  allauthors();     /* defined in file listauthors.c */
  extern  void  find_author();    /* defined in file listwriter.c */
  extern  void  find_year();      /* defined in file listpubyear.c */
  extern  void  viewref();        /* defined in file listref.c */
  extern  void  alluplinks();     /* defined in file listuplinks.c */


                    /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

                    /* form the outline of the window */

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL); 
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile select");
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size(GTK_WINDOW(window), 420, 160);
  panel = gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window), panel);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);
  description = gtk_label_new("Select a reference database probe");
  gtk_box_pack_start_defaults(GTK_BOX(panel), description);
  selectionKeypad = gtk_table_new(5, 4, TRUE);
  gtk_widget_set_usize(GTK_WIDGET(selectionKeypad), 390, 180);
  gtk_box_pack_start_defaults(GTK_BOX(panel), selectionKeypad);
  separator = gtk_hseparator_new();
  gtk_box_pack_start_defaults(GTK_BOX(panel), separator);
  keycentre = gtk_table_new(1, 3, TRUE);
  gtk_box_pack_start_defaults(GTK_BOX(panel), keycentre);
  finish = gtk_button_new_with_label("Cancel");
  gtk_widget_set_usize(GTK_WIDGET(keycentre), 390, 30);
  g_signal_connect(GTK_OBJECT(finish), "clicked",
                   G_CALLBACK(close_window), NULL);
  gtk_table_attach_defaults(GTK_TABLE(keycentre), finish, 1, 2, 0, 1);
  gtk_tooltips_set_tip(tooltips, finish,
                      "Finished inspecting that reference database", NULL);

                    /* connect the List all references present process */
  allkey = gtk_button_new_with_label("List all");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            allkey, 0, 1, 0 ,1);
  g_signal_connect(GTK_OBJECT(allkey), "clicked",
                   G_CALLBACK(all), NULL);
  gtk_tooltips_set_tip(tooltips, allkey,
                       "Show all ref_type/tag/title fields", NULL);

                    /* List the authors of all references present */
  allauthorkey = gtk_button_new_with_label("List all authors");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            allauthorkey, 0, 1, 1 ,2);
  g_signal_connect(GTK_OBJECT(allauthorkey), "clicked",
                   G_CALLBACK(allauthors), NULL);
  gtk_tooltips_set_tip(tooltips, allauthorkey,
                       "Show ref_type/tag/title tag fields for all author fields in database", NULL);

                    /* List the publication year of all references present */
  allyearkey = gtk_button_new_with_label("List all years");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            allyearkey, 0, 1, 2 ,3);
  g_signal_connect(GTK_OBJECT(allyearkey), "clicked",
                   G_CALLBACK(allyears), NULL);
  gtk_tooltips_set_tip(tooltips, allyearkey,
                       "Show ref_type/tag/title fields for all publication fields in database", NULL);

                    /* connect the List references by word present */
  wordkey = gtk_button_new_with_label("List by word");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            wordkey, 1, 2, 0 ,1);
  g_signal_connect(GTK_OBJECT(wordkey), "clicked",
                   G_CALLBACK(word), NULL);
  gtk_tooltips_set_tip(tooltips, wordkey,
                       "Show ref_type/tag/title fields corresponding to matches of specified word", NULL);

                    /* connect the List references by specified author */
  authorkey = gtk_button_new_with_label("List by author");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            authorkey, 1, 2, 1 ,2);
  g_signal_connect(GTK_OBJECT(authorkey), "clicked",
                   G_CALLBACK(find_author), NULL);
  gtk_tooltips_set_tip(tooltips, authorkey,
                       "Show ref_type/tag/title fields corresponding to specified author", NULL);


                    /* connect the List references by year of publication */
  yearkey = gtk_button_new_with_label("List by year");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            yearkey, 1, 2, 2 ,3);
  g_signal_connect(GTK_OBJECT(yearkey), "clicked",
                   G_CALLBACK(find_year), NULL);
  gtk_tooltips_set_tip(tooltips, yearkey,
                       "Show ref_type/tag/title fields for a specified year",
		       NULL);

                    /* connect the List references by publishing journal */
  journalkey = gtk_button_new_with_label("FUTURE 1");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            journalkey, 1, 2, 3 ,4);
  gtk_tooltips_set_tip(tooltips, journalkey,
                       "Not currently used", NULL);

                    /* connect the List references by reference type */
  typekey = gtk_button_new_with_label("FUTURE 2");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            typekey, 1, 2, 4 ,5);
  gtk_tooltips_set_tip(tooltips, typekey,
                       "Not currently used", NULL);
  future3 = gtk_button_new_with_label("FUTURE 3");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            future3, 1, 2, 5 ,6);
  gtk_tooltips_set_tip(tooltips, future3,
                       "Not currently used", NULL);

                    /* connect the List references uplinks given */
  uplinkkey = gtk_button_new_with_label("List by uplink");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            uplinkkey, 2, 3, 0 ,1);
  g_signal_connect(GTK_OBJECT(uplinkkey), "clicked",
                   G_CALLBACK(alluplinks), NULL);
  gtk_tooltips_set_tip(tooltips, uplinkkey,
                       "List reference citations via 'uplink' mechanism", NULL);

                    /* find the whole reference via its tag */
  refkey = gtk_button_new_with_label("View Reference");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            refkey, 3, 4, 0 ,1);
  g_signal_connect(GTK_OBJECT(refkey), "clicked",
                   G_CALLBACK(viewref), NULL);
  gtk_tooltips_set_tip(tooltips, refkey,
                       "View whole reference accessed via its tag", NULL);

                    /* make the composite window visible on the screen */
  gtk_widget_show_all(window);
}
